@extends('layouts.app')

@section('content')
    <!--.side-menu-->

    <h2 class="text-center text-secondary pb-2">PANEL DE CONTROL</h2>

    <div class="container-fluid text-center">
        <div class="row">

            <!--.col-->
            <div class="col-12">
                <div class="row">
                    <div class="col-12 col-sm-6 col-lg-4">
                        <article class="statistic-box bg-primary">
                            <div>
                                @foreach ($curso as $item)
                                    <div class="number text-light">{{ $item->total }}</div>
                                @endforeach
                                <div class="caption">
                                    <div>CURSOS</div>
                                </div>
                            </div>
                        </article>
                    </div>
                    <!--.col-->
                    <div class="col-12 col-sm-6 col-lg-4">
                        <article class="statistic-box purple">
                            <div>
                                @foreach ($participante as $item)
                                    <div class="number text-light">{{ $item->total }}</div>
                                @endforeach
                                <div class="caption">
                                    <div>PARTICIPANTES</div>
                                </div>
                            </div>
                        </article>
                    </div>
                    <!--.col-->
                    <div class="col-12 col-sm-6 col-lg-4">
                        <article class="statistic-box green">
                            <div>
                                @foreach ($usuario as $item)
                                    <div class="number text-light">{{ $item->total }}</div>
                                @endforeach
                                <div class="caption">
                                    <div>USUARIOS</div>
                                </div>
                            </div>
                        </article>
                    </div>
                </div>
                <!--.row-->
            </div>
            <!--.col-->

            <div class="col-12 mt-4 mb-4">
                <div class="row">
                    <div class="col-md-4">
                        <div class="card shadow-sm">
                            <div class="card-header bg-warning text-white font-weight-bold">
                                <i class="fas fa-clock mr-2"></i> Próximos Cursos
                            </div>
                            <ul class="list-group list-group-flush" style="max-height: 300px; overflow-y: auto;">
                                @forelse($cursoProx as $c)
                                    <li class="list-group-item">
                                        <div class="font-weight-bold">{{ $c->nombre }}</div>
                                        <small class="text-muted"><i class="far fa-calendar-alt"></i> Inicio: {{ $c->inicio }}</small>
                                    </li>
                                @empty
                                    <li class="list-group-item text-center text-muted">No hay cursos próximos</li>
                                @endforelse
                            </ul>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="card shadow-sm">
                            <div class="card-header bg-success text-white font-weight-bold">
                                <i class="fas fa-chalkboard-teacher mr-2"></i> En Curso
                            </div>
                            <ul class="list-group list-group-flush" style="max-height: 300px; overflow-y: auto;">
                                @forelse($cursoEncu as $c)
                                    <li class="list-group-item">
                                        <div class="font-weight-bold">{{ $c->nombre }}</div>
                                        <small class="text-muted"><i class="far fa-calendar-alt"></i> Inicio: {{ $c->inicio }}</small>
                                    </li>
                                @empty
                                    <li class="list-group-item text-center text-muted">No hay cursos en curso</li>
                                @endforelse
                            </ul>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="card shadow-sm">
                            <div class="card-header bg-secondary text-white font-weight-bold">
                                <i class="fas fa-check-circle mr-2"></i> Finalizados
                            </div>
                            <ul class="list-group list-group-flush" style="max-height: 300px; overflow-y: auto;">
                                @forelse($cursoFina as $c)
                                    <li class="list-group-item">
                                        <div class="font-weight-bold">{{ $c->nombre }}</div>
                                        <small class="text-muted"><i class="far fa-calendar-alt"></i> Término: {{ $c->termino }}</small>
                                    </li>
                                @empty
                                    <li class="list-group-item text-center text-muted">No hay cursos finalizados</li>
                                @endforelse
                            </ul>
                        </div>
                    </div>
                </div>
            </div>

            <!--.col-->
            <div class="container" style="width: 100%;">
                <canvas id="grafica" height="90"></canvas>
            </div>
            <!--.row-->

        </div>
    </div>

    <!--.container-fluid-->
    <!--.page-content-->
    </body>
@endsection
